/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.sequence.IRichSequenceBase;
import icyllis.flexmark.util.sequence.MappedSequence;
import icyllis.flexmark.util.sequence.RichSequence;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;
import icyllis.flexmark.util.sequence.builder.RichSequenceBuilder;
import icyllis.flexmark.util.sequence.mappers.CharMapper;

public class MappedRichSequence
extends IRichSequenceBase<RichSequence>
implements RichSequence,
MappedSequence<RichSequence> {
    private final CharMapper mapper;
    private final RichSequence base;

    private MappedRichSequence(CharMapper mapper, RichSequence baseSeq) {
        super(0);
        this.base = baseSeq;
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public CharMapper getCharMapper() {
        return this.mapper;
    }

    @Override
    @NotNull
    public RichSequence getCharSequence() {
        return this.base;
    }

    @Override
    public char charAt(int index) {
        return this.mapper.map(this.base.charAt(index));
    }

    public RichSequence getBaseSequence() {
        return this.base;
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @NotNull
    public RichSequence[] emptyArray() {
        return (RichSequence[])this.base.emptyArray();
    }

    @Override
    @NotNull
    public RichSequence nullSequence() {
        return (RichSequence)this.base.nullSequence();
    }

    @Override
    @NotNull
    public RichSequence sequenceOf(@Nullable CharSequence baseSeq, int startIndex, int endIndex) {
        if (baseSeq instanceof MappedRichSequence) {
            return startIndex == 0 && endIndex == baseSeq.length() ? (RichSequence)baseSeq : (RichSequence)((RichSequence)((RichSequence)baseSeq).subSequence(startIndex, endIndex)).toMapped(this.mapper);
        }
        return new MappedRichSequence(this.mapper, (RichSequence)this.base.sequenceOf(baseSeq, startIndex, endIndex));
    }

    @Override
    @NotNull
    public <B extends ISequenceBuilder<B, RichSequence>> B getBuilder() {
        return (B)RichSequenceBuilder.emptyBuilder();
    }

    @Override
    @NotNull
    public RichSequence toMapped(CharMapper mapper) {
        return mapper == CharMapper.IDENTITY ? this : new MappedRichSequence(this.mapper.andThen(mapper), this.base);
    }

    @Override
    @NotNull
    public RichSequence subSequence(int startIndex, int endIndex) {
        RichSequence baseSequence = (RichSequence)this.base.subSequence(startIndex, endIndex);
        return baseSequence == this.base ? this : new MappedRichSequence(this.mapper, baseSequence);
    }

    public static RichSequence mappedOf(CharMapper mapper, RichSequence baseSeq) {
        return MappedRichSequence.mappedOf(mapper, baseSeq, 0, baseSeq.length());
    }

    public static RichSequence mappedOf(CharMapper mapper, RichSequence baseSeq, int startIndex) {
        return MappedRichSequence.mappedOf(mapper, baseSeq, startIndex, baseSeq.length());
    }

    public static RichSequence mappedOf(CharMapper mapper, RichSequence baseSeq, int startIndex, int endIndex) {
        if (baseSeq instanceof MappedRichSequence) {
            return startIndex == 0 && endIndex == baseSeq.length() ? (RichSequence)baseSeq.toMapped(mapper) : (RichSequence)((RichSequence)baseSeq.subSequence(startIndex, endIndex)).toMapped(mapper);
        }
        return new MappedRichSequence(mapper, (RichSequence)baseSeq.subSequence(startIndex, endIndex));
    }
}

